import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample02_Retail_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleInvert(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText(
                  "${store_name}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    24,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText(
              "${order_number}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${datetime}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "${order_types}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "Served by ${staff_name}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("Transaction ${transaction}\n")
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.quantity} x ${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(37),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "${item_list.price%8.2f} T\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    10,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText("${item_list.detail}"),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText("Subtotal")
            .actionPrintText(
              "${subtotal_price%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                40,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("Tax")
            .actionPrintText(
              "${tax%8.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                45,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(true)
            .actionPrintText("Total")
            .actionPrintText(
              "${total_price%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                43,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(false)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText(
              "${payment_method}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${payment_amount%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText(
              "${address}\n" + "${telephone_number}\n" + "${footer}\n",
            )
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${barcode}",
                StarXpandCommand.Printer.BarcodeSymbology.Code128,
              )
                .setBarDots(1)
                .setPrintHri(true),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Star Store",
    "order_number" : "#2-023",
    "datetime" : "7/16/21, 10:00 AM",
    "order_types" : "Sale",
    "staff_name" : "John",
    "transaction" : "#74735210207161910007",
    "item_list" : [
        {
            "name" : "Star Hoodie",
            "quantity" : 1,
            "price" : 30.0,
            "detail" : "   (Medium, Green)\\n"
        },
        {
            "name" : "Star Magnet",
            "quantity" : 1,
            "price" : 6.99,
            "detail" : ""
        },
        {
            "name" : "French Roast",
            "quantity" : 1,
            "price" : 3.75
        }
    ],
    "subtotal_price" : 40.74,
    "tax" : 3.61,
    "total_price" : 44.35,
    "payment_method" : "Cash",
    "payment_amount" : 44.35,
    "address" : "1234 Star Street\\nNew York, NY, 10016\\nUnited States",
    "telephone_number" : "800-456-7890",
    "footer" : "Powered by: StarXpand SDK",
    "barcode" : "74735210207161910007"
}`,
    );
  }
}
